﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.IO;
using System.IO.Compression;

namespace ProCon2011PlayerClient
{
    public partial class ClientForm : Form
    {

        private string ServerURL
        {
            get { return textBoxServerURL.Text; }
        }

        private string PlayerID
        {
            get { return textBoxPlayerID.Text; }
        }

        public ClientForm()
        {
            InitializeComponent();
        }

        public int ProblemNumber
        {
            get
            {
                return (int)numericUpDownGetProblemNumber.Value;
            }
        }

        private void buttonGetProblemData_Click(object sender, EventArgs e)
        {
            saveFileDialogProblem.FileName = "problem" + ProblemNumber + ".txt";
            if (saveFileDialogProblem.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                var filePath = saveFileDialogProblem.FileName;
                string problem = WebAccessor.DownloadProblem(ServerURL, PlayerID, ProblemNumber);
                WriteFile(problem, filePath);
            }
        }

        private void WriteFile(string text, string path)
        {
            using (var sw = new StreamWriter(path))
            {
                sw.Write(text);
            }
        }

        private void buttonSelectFile_Click(object sender, EventArgs e)
        {
            if (openFileDialogAnswer.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                textBoxAnswerFilePath.Text = openFileDialogAnswer.FileName;
            }
        }

        private void buttonCheckConnection_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(ServerURL) ||
                string.IsNullOrEmpty(PlayerID))
            {
                MessageBox.Show("There are some blank fields.");
                return;
            }

            if (ServerURL.EndsWith("/"))
            {
                MessageBox.Show("Server URL must not end with '/'.");
                return;
            }

            string ret;

            try
            {
                ret = WebAccessor.CheckParameters(ServerURL, PlayerID);
            }
            catch (WebException)
            {
                ret = "Server is not found.";
            }
            if (ret == "OK")
            {
                groupBox2.Enabled = true;
                groupBox3.Enabled = true;
            }

            label6.Text = ret;
        }

        private void buttonSubmit_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(textBoxAnswerFilePath.Text))
            {
                MessageBox.Show("Answer file is not selected.");
                return;
            }

            string answer;
            using (var sr = new StreamReader(textBoxAnswerFilePath.Text))
            {
                answer = sr.ReadToEnd();
            }

            string ret;
            try
            {
                ret = WebAccessor.SubmitAnswer(ServerURL, PlayerID, ProblemNumber, answer);

            }
            catch (Exception ex)
            {
                ret = "Connection error:" + ex.Message;
            }
            MessageBox.Show(ret);
        }
    }
}
